package com.baiyi.demo;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

/**
 * Servlet implementation class LoginServlet
 */
@WebServlet("/LoginServlet")
public class LoginServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public LoginServlet() {
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		try {
			// 读取请求参数
			String username = request.getParameter("username");
			String password = request.getParameter("password");
			String sso = request.getParameter("sso");
			String sig = request.getParameter("sig");

			// 验证用户名、密码是否正确，需替换为真实的登录处理逻辑
			if (!"demo@101test.com".equals(username)
					|| !"123456".equals(password)) {
				request.setAttribute("error", "用户名或密码不正确");
				request.getRequestDispatcher("/login.jsp").forward(request,
						response);
				return;
			}

			// 创建加密对象，加密串需在企业端管理页面获取
			SecretKey secretKey = new SecretKeySpec(
					"1234567890abcdefghijklmnopqrstuv".getBytes(), "HmacSHA256");
			Mac mac = Mac.getInstance(secretKey.getAlgorithm());
			mac.init(secretKey);

			// 检查签名是否一致，防止非授权页面的访问
			String data = Hex.encodeHexString(mac.doFinal(sso.getBytes()));
			if (!data.equals(sig)) {
				request.setAttribute("error", "签名不一致");
				request.getRequestDispatcher("/login.jsp").forward(request,
						response);
				return;
			}

			// 解析参数
			String nonce = null;
			String returnSsoUrl = null;
			String queryString = new String(Base64.decodeBase64(sso));
			String[] fields = queryString.split("&");
			for (String field : fields) {
				String[] kv = field.split("=");
				if (kv.length != 2)
					continue;

				if (kv[0].equals("nonce"))
					nonce = kv[1];
				else if (kv[0].equals("return_sso_url"))
					returnSsoUrl = URLDecoder.decode(kv[1], "UTF-8");
			}

			/**
			 * 拼装回调链接
			 * <p>
			 * nonce: 传入值
			 * <p>
			 * name: 用户名，用于显示，需编码
			 * <p>
			 * external_id: 帐号唯一id，可以是任何值，外部系统中同一个帐号必须相同，需编码
			 */
			StringBuilder builder = new StringBuilder();
			builder.append("nonce=");
			builder.append(nonce);
			builder.append("&name=");
			builder.append(URLEncoder.encode("demo帐号", "UTF-8"));
			builder.append("&external_id=");
			builder.append(URLEncoder.encode("demo@101test.com", "UTF-8"));

			// 生成签名
			String newSso = Base64.encodeBase64String(builder.toString()
					.getBytes());
			String newSig = Hex.encodeHexString(mac.doFinal(newSso.getBytes()));

			// 登录成功后，跳转到回调地址
			response.sendRedirect(returnSsoUrl + "?sso="
					+ URLEncoder.encode(newSso, "UTF-8") + "&sig=" + newSig);
		} catch (Exception e) {
			request.setAttribute("error", "系统异常");
			request.getRequestDispatcher("/login.jsp").forward(request,
					response);
		}
	}
}
