<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>登录样例</title>
    <style type="text/css">
        body {
            background: #e4e7ea;
            font-family: sans-serif !important;
            line-height: 14px;
            color: #636e7b;
            max-width: 300px;
            margin: 0 auto;
        }

        .box {
            box-sizing: border-box;
        }

        .login-panel {
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid #ccc;
            box-shadow: 0 3px 0 rgba(12, 12, 12, 0.03);
            border-radius: 3px;
            padding: 70px 30px 50px;
            margin: 50px auto;
            position: relative;
        }

        .login-panel p.title {
            font-size: 18px;
            font-weight: bold;
            color: #AAB2BD;
            position: absolute;
            right: 30px;
            top: 20px;
        }

        .login-panel p.error {
            color: #E9573F;
            font-size: 13px;
            margin: 15px 0 0;
            text-align: center;
        }

        label {
            font-size: 13px;
        }

        label > span {
            color: #AAB2BD;
            margin-left: 10px;
        }

        .form-control {
            box-sizing: border-box;
            display: block;
            margin: 5px auto 15px;
            width: 100%;
            -webkit-border-radius: 3px;
            height: 34px;
            padding: 6px 12px;
            font-size: 14px;
            line-height: 1.42857143;
            color: #555;
            /*background-color: #fff !important;*/
            border: 1px solid #ccc;
            border-radius: 4px;
            box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        }

        .form-control:focus {
            outline: 0;
            border-color: #999;
            box-shadow: 3px 3px 0 rgba(12, 12, 12, 0.05);
        }

        .btn {
            display: block;
            width: 100%;
            color: #fff;
            padding: 6px 12px;
            margin-bottom: 0;
            font-size: 14px;
            font-weight: 400;
            line-height: 1.42857143;
            text-align: center;
            white-space: nowrap;
            vertical-align: middle;
            cursor: pointer;
            user-select: none;
            background-image: none;
            border: 1px solid transparent;
            border-radius: 4px;
        }

        .btn:active {
            outline: 0 !important;
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, .125);
        }

        .btn[disabled] {
            pointer-events: none;
            opacity: 0.65;
        }

        .btn-login {
            margin-top: 30px;
            border-color: #37bc9b;
            background-color: #37bc9b;
        }

        .btn-login:hover {
            outline: 0 !important;
            border-color: #48cfad;
            background-color: #48cfad;
        }

    </style>
</head>
<body>
<section>
    <div class="login-panel box">
        <form action="login" method="post">
            <p class="title">登录样例</p>
            <label for="username">用户名<span>demo@101test.com</span></label>
            <input type="text" id="username" name="username" class="form-control box" placeholder="请输入用户名"
                   value="demo@101test.com">
            <label for="password">密码<span>123456</span></label>
            <input type="password" id="password" name="password" class="form-control box" placeholder="请输入密码"
                   value="123456">
            <input type="submit" value="登录" id="submit" class="btn btn-login" disabled>
            <p class="error">${requestScope.error}</p>
        </form>
    </div><!-- login-panel -->
</section>
<script>
    (function () {
        document.querySelector('form').setAttribute('action', 'login' + window.location.search)
        document.querySelector('#submit').removeAttribute('disabled')
    })();
</script>
</html>